/**********
* File: WinDataTypes.h

* Brief Description: This file contains typedefinitions and macro definitions
					 Refered to MSDN - Windows Data Types

* Written By: Shilpa Prabhu 

* Copyright: 1994-2004 by Robosoft Technologies, all rights reserved.

* Date Of Creation: 15Oct04

* Change History (Most Recent First):

**********/


#ifndef _WINDATATYPES_H_
#define  _WINDATATYPES_H_
#ifdef   USE_WINDATATYPES
//#include "wchar.h"


//! Macros --------------------------------
#define STDMETHOD(x)	x
#define HRESULT			int
#define APIDEBUG(x)		
#define IAPIDEBUG(x)
#define MAPIDEBUG(x)
#define RAPIDEBUG(x)
#define MESG(x)
#define ASSERT(x)
#define CONST			const
#define LPBYTE					unsigned char *
#define PBYTE					unsigned char *

// Rashmi - added #if 0 since its conflicting with SystemX - Start

#if 0
//! Data types -----------------------------
typedef unsigned long   DWORD;
typedef int				BOOL;
typedef unsigned char   BYTE;
typedef unsigned short  WORD;
typedef float			FLOAT;




typedef unsigned long   ULONG;
typedef unsigned short  USHORT;
typedef unsigned char   UCHAR;
typedef unsigned int	UINT;
typedef unsigned int UINT_PTR;

typedef char CHAR;
typedef wchar_t WCHAR;

#ifdef UNICODE
typedef WCHAR TCHAR;
#else
typedef char TCHAR;
#endif

typedef long	LONG;
typedef short   SHORT;
typedef int		INT;

typedef void	VOID;
typedef void	*PVOID;
typedef void	*LPVOID;
typedef PVOID   HANDLE;
typedef HANDLE  *PHANDLE;

typedef CONST CHAR *LPCSTR;
typedef CONST WCHAR *LPCWSTR;
typedef HANDLE HINSTANCE;
typedef HINSTANCE HMODULE;
typedef CONST void *LPCVOID;
typedef DWORD *LPDWORD;



typedef HANDLE  HWND; //-----????Need to be WindowRef - check this-----
typedef HANDLE  HMONITOR;







//---Need to check - shilpa.
//#define GUID		int
//#define REFIID		int
#define ULONG_PTR 	UInt32*
#define LONG_PTR 	SInt32*
#define HDC			DWORD   // Yogesh: May not be correct 

#define CALLBACK 
#define WINAPI 
#define interface
#define STDMETHODCALLTYPE

//
//typedef struct _OVERLAPPED { 
//    ULONG_PTR  Internal; 
//    ULONG_PTR  InternalHigh; 
//    DWORD  Offset; 
//    DWORD  OffsetHigh; 
//    HANDLE hEvent; 
//} OVERLAPPED;
//

typedef struct _OVERLAPPED {
    ULONG_PTR Internal;
    ULONG_PTR InternalHigh;
    DWORD   Offset;
    DWORD   OffsetHigh;
    HANDLE  hEvent;
} OVERLAPPED, *LPOVERLAPPED;

//typedef struct _FILETIME {
//    DWORD dwLowDateTime;   // low 32 bits  
//    DWORD dwHighDateTime;  // high 32 bits 
//} FILETIME, *PFILETIME, *LPFILETIME;


typedef struct _FILETIME {
    DWORD dwLowDateTime;
    DWORD dwHighDateTime;
} FILETIME, *PFILETIME, *LPFILETIME;
//typedef struct tagRECT
//{
//    LONG    left;
//    LONG    top;
//    LONG    right;
//    LONG    bottom;
//} RECT, *PRECT, *LPRECT;
typedef struct tagRECT
{
    LONG    left;
    LONG    top;
    LONG    right;
    LONG    bottom;
} RECT, *PRECT,*NPRECT,*LPRECT;

//typedef struct tagPOINT
//{
//    LONG  x;
//    LONG  y;
//} POINT, *PPOINT;

typedef struct tagPOINT
{
    LONG  x;
    LONG  y;
} POINT, *PPOINT,*NPPOINT,*LPPOINT;

//typedef struct _RGNDATAHEADER {
//    DWORD   dwSize;
//    DWORD   iType;
//    DWORD   nCount;
//    DWORD   nRgnSize;
//    RECT    rcBound;
//} RGNDATAHEADER, *PRGNDATAHEADER;

typedef struct _RGNDATAHEADER {
    DWORD   dwSize;
    DWORD   iType;
    DWORD   nCount;
    DWORD   nRgnSize;
    RECT    rcBound;
} RGNDATAHEADER, *PRGNDATAHEADER;
//typedef struct _RGNDATA {
//    RGNDATAHEADER   rdh;
//    char            Buffer[1];
//} RGNDATA, *PRGNDATA;
typedef struct _RGNDATA {
    RGNDATAHEADER   rdh;
    char            Buffer[1];
} RGNDATA, *PRGNDATA,*NPRGNDATA,*LPRGNDATA;

//typedef struct tagPALETTEENTRY
//{
//	BYTE peRed;
//	BYTE peGreen;
//	BYTE peBlue;
//	BYTE peFlags;
//}PALETTEENTRY;

typedef struct tagPALETTEENTRY {
    BYTE        peRed;
    BYTE        peGreen;
    BYTE        peBlue;
    BYTE        peFlags;
} PALETTEENTRY, *PPALETTEENTRY,*LPPALETTEENTRY;

typedef struct tagLOGFONT { 
  LONG lfHeight; 
  LONG lfWidth; 
  LONG lfEscapement; 
  LONG lfOrientation; 
  LONG lfWeight; 
  BYTE lfItalic; 
  BYTE lfUnderline; 
  BYTE lfStrikeOut; 
  BYTE lfCharSet; 
  BYTE lfOutPrecision; 
  BYTE lfClipPrecision; 
  BYTE lfQuality; 
  BYTE lfPitchAndFamily; 
  //TCHAR lfFaceName[LF_FACESIZE]; 
  TCHAR lfFaceName[256]; 
} LOGFONT, *PLOGFONT;


#endif
// Rashmi - added, since its conflicting with SystemX - End 


#ifndef GUID_DEFINED
#define GUID_DEFINED
//typedef struct _GUID
//{
//    unsigned long Data1;
//    unsigned short Data2;
//    unsigned short Data3;
//    unsigned char Data4[8];
//} GUID;
//#ifdef __midl
//
//typedef struct {
//#else
	typedef struct _GUID {
//#endif
		unsigned long  Data1;
		unsigned short Data2;
		unsigned short Data3;
		unsigned char  Data4[ 8 ];
	} GUID;
//#endif
#ifndef INITGUID

#define DEFINE_GUID(name, l, w1, w2, b1, b2, b3, b4, b5, b6, b7, b8) \
	    EXTERN_C const GUID name
#else

#define DEFINE_GUID(name, l, w1, w2, b1, b2, b3, b4, b5, b6, b7, b8) \
        EXTERN_C const GUID name \
                = { l, w1, w2, { b1, b2,  b3,  b4,  b5,  b6,  b7,  b8 } }
#endif // INITGUID



#endif /* GUID_DEFINED */

#define IID					GUID
#define CLSI				GUID
#define FMTID				GUID

#define REFGUID             const GUID &
#define REFIID              const IID &
#define REFCLSID            const CLSID &
#define REFFMTID            const FMTID &
#define __RPC_FAR	


#define DECLARE_INTERFACE_(x, y )  class x : public y
//#define STDMETHOD(x) virtual HRESULT  x  // bala : commented redefinition of 'STDMETHOD'
#define STDMETHOD_(x , y ) virtual x y
#define PURE = 0


class IUnknown
{
public:
    virtual HRESULT STDMETHODCALLTYPE QueryInterface(REFIID riid, void **ppvObject) = 0;
    
    virtual ULONG STDMETHODCALLTYPE AddRef( void) = 0;
    
    virtual ULONG STDMETHODCALLTYPE Release( void) = 0;
};


//---------------------------------------------------------------
// Added by Shama K.S - Start

// If any of the definations are not correct then replace with correct one.
// Not sure of all of the definations

//typedef unsigned long *  DWORD_PTR;  //Rashmi - commented, conflicting with SystemX framework definition.

typedef long * LPLONG ;

typedef void * LPUNKNOWN ;

#define EXTERN_C extern

#define THIS_
#define THIS

#define SAFE_RELEASE delete
typedef char * LPTSTR;
typedef GUID * LPGUID;

//Dummy   ( TO DO : Check the correct value of this data )
//#define GUID_NULL 0  //Rashmi - commented, conflicting with SystemX framework definition.
// Dummy

//Dummy structure

//typedef struct { 
//  WORD  wFormatTag; 
//  WORD  nChannels; 
//  DWORD nSamplesPerSec; 
//  DWORD nAvgBytesPerSec; 
//  WORD  nBlockAlign; 
//  WORD  wBitsPerSample; 
//  WORD  cbSize; 
//} WAVEFORMATEX , *LPWAVEFORMATEX; 
 
#ifndef _WAVEFORMATEX_
#define _WAVEFORMATEX_

typedef struct tWAVEFORMATEX
{
    WORD        wFormatTag;         // format type 
    WORD        nChannels;          // number of channels (i.e. mono, stereo...) 
    DWORD       nSamplesPerSec;     // sample rate 
    DWORD       nAvgBytesPerSec;    // for buffer estimation 
    WORD        nBlockAlign;        // block size of data 
    WORD        wBitsPerSample;     // number of bits per sample of mono data 
    WORD        cbSize;             // the count in bytes of the size of 
                                    // extra information (after cbSize) 
} WAVEFORMATEX, *PWAVEFORMATEX,*NPWAVEFORMATEX,*LPWAVEFORMATEX; 
 
#endif


#ifndef __LPCGUID_DEFINED__
#define __LPCGUID_DEFINED__
typedef const GUID *LPCGUID;
#endif // __LPCGUID_DEFINED__

#ifndef _LPCWAVEFORMATEX_DEFINED
#define _LPCWAVEFORMATEX_DEFINED
typedef const WAVEFORMATEX *LPCWAVEFORMATEX;
#endif // _LPCWAVEFORMATEX_DEFINED

#define MAKE_HRESULT(sev,fac,code) ((HRESULT) (((unsigned long)(sev)<<31) | ((unsigned long)(fac)<<16) | ((unsigned long)(code))) )



#define RETURN_RESULT(str) 										\
	if (the_lResult) {												\
		printf ("Error:%s=0x%lX,%ld,%s\n\n",		 			\
						str,the_lResult, the_lResult, (char*)&the_lResult);	\
		fflush (stdout);										\
        return the_lResult;											\
	}

 


// Added by Shama K.S - End
//---------------------------------------------------------------

 //Rashmi added #if 0, conflicting with SystemX framework definition. Start

#if 0


 //Direct3D Errors
 
 //shilpa on 26 Oct 04 - brought this enum definition from MSDN. 
 #ifndef __D3DERR_ENUM__
 #define __D3DERR_ENUM__
typedef enum{
	D3D_OK,
	D3DOK_NOAUTOGEN,
	D3DERR_CONFLICTINGRENDERSTATE,
	D3DERR_CONFLICTINGTEXTUREFILTER,
	D3DERR_CONFLICTINGTEXTUREPALETTE,
	D3DERR_DEVICELOST,
	D3DERR_DEVICENOTRESET,
	D3DERR_DRIVERINTERNALERROR,
	D3DERR_DRIVERINVALIDCALL,
	D3DERR_INVALIDCALL,
	D3DERR_INVALIDDEVICE,
	D3DERR_MOREDATA,
	D3DERR_NOTAVAILABLE,
	D3DERR_NOTFOUND,
	D3DERR_OUTOFVIDEOMEMORY,
	D3DERR_TOOMANYOPERATIONS,
	D3DERR_UNSUPPORTEDALPHAARG,
	D3DERR_UNSUPPORTEDALPHAOPERATION,
	D3DERR_UNSUPPORTEDCOLORARG,
	D3DERR_UNSUPPORTEDCOLOROPERATION,
	D3DERR_UNSUPPORTEDFACTORVALUE,
	D3DERR_UNSUPPORTEDTEXTUREFILTER,
	D3DERR_WASSTILLDRAWING,
	D3DERR_WRONGTEXTUREFORMAT,
	E_FAIL,
	E_INVALIDARG,
	E_INVALIDCALL,
	E_NOINTERFACE,
	E_NOTIMPL,
	E_OUTOFMEMORY,
	//S_OK - shilpa commented this - this should be same as D3D_OK i.e. 0.
}D3DERR;

#define S_OK								0 

#endif //__D3DERR_ENUM__
 
#endif

//Rashmi added #if 0, conflicting with SystemX framework definition - End.

#else
#if defined(__cplusplus)
/* ================= IUnknown definition (C++ class) ================= */

/* This is a definition of IUnknown as a pure abstract virtual C++ class.  This class will work only with compilers that can produce COM-compatible object layouts for C++ classes.  egcs can not do this.  MetroWerks can do this (if you subclass from __comobject) */
//chandan-20.06.09
#ifndef TARGET_OS_MAC
class IUnknown
	{
	public:
		virtual long  QueryInterface(REFIID iid, void* *ppv) = 0;
		virtual unsigned long  AddRef(void) = 0;
		virtual unsigned long  Release(void) = 0;
	};
//#include "robolib_com.h"
typedef struct IUnknown* LPUNKNOWN;
#endif //RD_MODIFIED
//till here

#endif

#include "windows.h"

#endif

#endif

